import java.util.*;

public class Jogo {
    static final int MAXN = 100010;
    static int[][] poderes = new int[MAXN][];
    static int[][] resp = new int[MAXN][];
    static int[][] ativo = new int[MAXN][];
    static int[][] indice = new int[MAXN][];
    static int[] pai = new int[MAXN];
    static int[] soma = new int[MAXN];
    static List<List<Celula>> componente = new ArrayList<>();
    static int[] dx = {0, 1, 0, -1};
    static int[] dy = {1, 0, -1, 0};

    static class Celula {
        int linha, coluna, poder;

        Celula(int linha, int coluna, int poder) {
            this.linha = linha;
            this.coluna = coluna;
            this.poder = poder;
        }
    }

    static int find(int v) {
        if (pai[v] == v) {
            return v;
        }
        pai[v] = find(pai[v]);  // Compressão de caminho
        return pai[v];
    }

    static void une(int a, int b) {
        a = find(a);
        b = find(b);

        if (a == b) return;

        if (componente.get(a).size() > componente.get(b).size()) {
            int temp = a;
            a = b;
            b = temp;
        }

        componente.get(b).addAll(componente.get(a));
        pai[a] = b;
        soma[b] += soma[a];
        componente.get(a).clear();
    }

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        while (true) {
            int n = sc.nextInt();
            int m = sc.nextInt();

            if (n == 0 && m == 0) break;

            List<Celula> celulas = new ArrayList<>();
            int idCounter = 0;

            for (int i = 0; i < n; i++) {
                poderes[i] = new int[m];
                resp[i] = new int[m];
                ativo[i] = new int[m];
                indice[i] = new int[m];
                for (int j = 0; j < m; j++) {
                    int p = sc.nextInt();
                    poderes[i][j] = p;
                    Celula nova = new Celula(i, j, p);
                    celulas.add(nova);
                    idCounter++;
                    indice[i][j] = idCounter;
                    ativo[i][j] = 0;
                    resp[i][j] = 0;
                }
            }

            // Ordena as células com base no poder
            celulas.sort(Comparator.comparingInt(celula -> celula.poder));

            for (Celula celula : celulas) {
                int l = celula.linha;
                int c = celula.coluna;
                int p = celula.poder;

                ativo[l][c] = 1;
                int id = indice[l][c] - 1;  // Ajuste para índice zero
                componente.get(id).add(celula);
                pai[id] = id;
                soma[id] = p;

                for (int k = 0; k < 4; k++) {
                    int vizl = l + dx[k];
                    int vizc = c + dy[k];
                    if (vizl < 0 || vizl >= n || vizc < 0 || vizc >= m) continue;
                    if (ativo[vizl][vizc] == 0) continue;

                    int vizid = indice[vizl][vizc] - 1;  // Ajuste para índice zero
                    int vizpai = find(vizid);

                    if (p <= soma[vizpai]) {
                        une(id, vizpai);
                    } else {
                        for (Celula vizcel : componente.get(vizpai)) {
                            resp[vizcel.linha][vizcel.coluna] = soma[vizpai];
                        }
                        componente.get(vizpai).clear();
                        une(vizpai, id);
                    }
                }
            }

            int llast = celulas.get(celulas.size() - 1).linha;
            int clast = celulas.get(celulas.size() - 1).coluna;
            int idlast = indice[llast][clast] - 1;  // Ajuste para índice zero
            int pailast = find(idlast);

            for (Celula vizcel : componente.get(pailast)) {
                resp[vizcel.linha][vizcel.coluna] = soma[pailast];
            }

            // Imprime a saída
            for (int i = 0; i < n; i++) {
                for (int j = 0; j < m; j++) {
                    System.out.print(resp[i][j] + (j == m - 1 ? "\n" : " "));
                }
            }
        }

        sc.close();
    }
}
